% ------------------------------------------------------------------------
% Script: infile_2d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 2D P-N model
% ------------------------------------------------------------------------

    % System name
 
    system='2d P-N model';
 
    % The absolute path to save the result files
 
    filepath=pwd;
 
    % The dimension of P-N model: 1 or 2 

    misdim=2;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------ 
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
 
    % % the data of GSFE (unit: J/m2) and normalized disregistry vector (unit: 1)
    
    [Ux,Uz]=meshgrid(0:0.1:1,0:0.0666:1);
    SFE=[-2.90951	69.72628	224.56225	367.08447	454.73073	485.38213	469.33994	400.70311	289.78477	169.09827	123.11608	148.64571	162.0506	124.9701	49.51141	0;
45.22157	83.70164	218.39972	352.56977	438.26522	467.48196	448.21221	375.66188	266.6004	168.81926	153.21286	193.41339	214.69676	186.05389	111.9127	48.04109;
153.01421	124.41378	200.6167	310.40655	386.92922	409.25505	381.22339	303.94576	207.58457	163.15419	211.24451	286.88997	321.23188	303.50829	238.32709	155.52529;
261.53862	174.3621	174.15326	243.60619	302.01363	311.5622	271.61125	189.88531	123.24228	155.8043	266.15217	367.51685	412.15154	404.73431	347.22218	258.4282;
330.05151	213.38547	148.87265	168.31048	205.61	203.45546	147.33555	66.1931	47.79717	149.54273	301.28753	414.1861	466.51929	464.4304	414.30268	321.80348;
353.50414	227.76775	132.11399	133.60807	159.11676	148.24842	88.31406	12.43713	15.74167	146.66038	311.55711	428.03469	481.2366	482.26945	434.94654	343.61997;
327.08655	211.9095	145.66885	165.23289	207.96771	210.68084	158.09807	73.06929	47.14464	145.97786	297.0939	410.99985	463.44792	460.24413	408.98623	316.90922;
257.95394	172.36263	170.41635	241.961	307.33462	323.64449	286.78018	200.8725	127.51458	153.82973	260.4339	359.87155	406.25443	397.57684	338.28257	249.05112;
151.23942	123.25191	197.76435	311.80895	391.62087	417.99149	392.2021	312.58259	211.54899	161.57917	207.45101	278.70589	312.77445	294.7243	228.26578	146.61398;
44.83277	85.1929	219.26391	353.68467	441.0372	470.90534	452.12853	379.33598	266.33893	167.56514	150.87156	189.12525	209.50141	178.58798	104.35908	42.57126;
1.13415	74.74561	228.39311	366.27914	453.94746	484.09857	467.88378	398.06751	285.34892	167.24255	125.30514	149.35031	159.372	120.339	43.95556	-5.66451]'/1E3;
 
    % % Which trial function of disregistry vector to employ (>=-1)
    
    Nmis=-1;     
     
    % % The value of Burgers vector (unit: A)
 
    BurVect=2.8567; 
 
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=31.8926;
    poisson_ratio=0.3203;
    
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='e';
    
    % % Which GSFE fitting function to employ (>=-1)
    
    fitcut=0;
    
    % % Mode of P-N models: CCPN (1) or SVPN (2)

    pnmode=2;
    
    % % Interplanar distance ?x (unit: A)
    
    Inpas=BurVect/2;
    
    % % The reference position x_m is defined as x_m=m?x+dax for SVPN model
    %   (m=0, 1, 2, , ?)
 
    dax=0.0;
 
   % % Matrix of the lower and upper bounds, and initial values of each unknown 
   %   variable ([Lower bound, Upper bound, StartPoint]) 
  
    Xcoef_range=[0.00, 1.00, 0.200];
    Xdist_range=[-50.00, 50.00, 8.00];
    Xwid_range=[0.00,20.00, 1.00];
    dx_range=[-5.00,5.00, 0.00];
    
    % % The minimization method for 2D P-N model: PSO ('2d_PSO') or GA ('2d_GA')
 
    minimethod='2d_PSO';   
    
    % % PSO or GA Parameters
 
        % % % Size of the population and maximum number of iteration
 
        PopulationSize=100;
        MaxIterations=1000;
       
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='FALSE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    % pnstrmethod=2;
    
    % % Interplanar distance ?x (unit: A) 

    % Inpas=BurVect;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='FALSE';
    
    % % The lattice matrix for pressure field
    
    % pressfld_latxz=[];
    % pressfld_latyy=[];
    
        % % % >>> For edge dislocation of FCC and HCP structures
 
        LatC_spacing=sqrt(2/3)/2*BurVect;
        [pressfld_latxz,pressfld_latyy]=meshgrid(-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect,...
                                       -(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing);
 
        % % % >>> For screw dislocation of FCC structure
 
        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+7/12)*BurVect:(1/2*BurVect):(6+11/12)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],10,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);
 
        % % % >>> For screw dislocation of HCP structure
 
        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],15,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);
 
    % % Which component of the dislocation to calculate: x or z
    
    % dis_component_xz='x';
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of solid solution strengthening
% ------------------------------------------------------------------------
 
    % % Calculating the solid solution strengthening ('TRUE') or NOT ('FALSE')
    
    Solution_Strengthening='TRUE';
    
    % % Plotting the position-dependent solute/dislocation interaction energy
    %   ('TRUE') or NOT ('FALSE')
    
    Einteraction_Plot='TRUE';
    
    % % The input volumetric misfit (eb_input) and slip misfit (es_input) parameters
    
    % [eb_input, es_input]=meshgrid(-1:0.1:1,-3:0.3:3);
    
    eb_input=[0.104 -0.107 -0.201 -0.242];
    es_input=[-0.38 0.22 0.49 0.84];
 
    % % The interlayer spacing along FCC [111] or HCP [0001] direction
 
    % LatC_spacing=[];

        % % % >>> for FCC structure

        LatC_spacing=sqrt(2/3)/2*BurVect; 
 
    % % The coefficient to calculate the extra volume (unit: A^3), i.e. dV=coefV*eb
    
    % coefV=[];

        % % % >>> for FCC structure
    
        coefV=3/4*(sqrt(2)*BurVect)^3;
        
    % % Matrix of the lower and upper bounds to search the characteristic bow-out distance wc (unit: A)
    
    wc_range=[0, 50];        
      
    % % Concentration of solute atom
 
    solute_concentration=1;
